/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.nhm.eui;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.eui.ColumnLayout;
import ibm.nways.nhm.eui.FileListPanel;
import ibm.nways.nhm.eui.HtmlFilenameFilter;
import ibm.nways.nhm.eui.NhmHelpRef;
import ibm.nways.nhm.eui.TimeSelectionPanel;
import ibm.nways.ras.Traces;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Label;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.URL;
import java.util.Date;
import java.util.ResourceBundle;
import jclass.bwt.JCCheckbox;
import jclass.bwt.JCCheckboxGroup;
import jclass.bwt.JCItemEvent;
import jclass.bwt.JCItemListener;

public class NhmReportDialog
extends Dialog
implements ActionListener,
JCItemListener,
WindowListener,
ItemListener {
    public static final int CANCEL = 1;
    public static final int LAUNCH = 2;
    public static final int ADD_APPLET = 3;
    public static final int SAVE = 4;
    public static final int EDIT = 5;
    public static final int ADD_IMAGE = 6;
    private int result = 1;
    private int dialogMode;
    private Applet applet;
    private int serverPort;
    private Image rptImage;
    private Image folderImage;
    private Image upOneLevelImage;
    private FileListPanel filePanel;
    private Button buttonOne;
    private Button pbCancel;
    private Button pbHelp;
    private Choice reportType;
    private JCCheckbox moreHostnames;
    private JCCheckboxGroup saveType;
    private TimeSelectionPanel timePanel;
    private ResourceBundle nhmRes = ResourceBundle.getBundle("ibm.nways.nhm.eui.NhmResources");
    private String serverHost;

    public NhmReportDialog(Frame frame, int n, Applet applet, String string, int n2) {
        super(frame, true);
        this.dialogMode = n;
        this.applet = applet;
        this.serverHost = string;
        this.serverPort = n2;
        if (this.dialogMode == 3) {
            this.setTitle(this.nhmRes.getString("s_addAppletTitle"));
            this.initializeAddAppletMode();
        } else if (this.dialogMode == 6) {
            this.setTitle(this.nhmRes.getString("s_addImageTitle"));
            this.initializeCommon();
            this.initializeButtons("s_Add");
        } else {
            this.setTitle(this.nhmRes.getString("s_loadTitle"));
            this.initializeCommon();
            if (this.dialogMode == 5) {
                this.initializeButtons("s_Edit");
            } else if (this.dialogMode == 4) {
                this.initializeButtons("s_Save");
            } else if (this.dialogMode == 2) {
                this.initializeButtons("s_Launch");
            }
        }
        this.pack();
        this.filePanel.requestFocus();
    }

    private void initializeCommon() {
        MediaTracker mediaTracker = new MediaTracker(this);
        Class<?> clazz = this.getClass();
        URL uRL = clazz.getResource("smreport.gif");
        this.rptImage = this.applet.getImage(uRL);
        uRL = clazz.getResource("smfolder.gif");
        this.folderImage = this.applet.getImage(uRL);
        uRL = clazz.getResource("smupone.gif");
        this.upOneLevelImage = this.applet.getImage(uRL);
        mediaTracker.addImage(this.rptImage, 0);
        mediaTracker.addImage(this.folderImage, 1);
        mediaTracker.addImage(this.upOneLevelImage, 2);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            Traces.logException(interruptedException);
        }
        this.setLayout(new ColumnLayout());
        this.filePanel = new FileListPanel(this.folderImage, this.rptImage, this.upOneLevelImage, this.serverHost, "reports", new HtmlFilenameFilter(), (Frame)this.getParent(), this.serverPort);
        this.add(this.filePanel);
        this.addWindowListener(this);
    }

    private void initializeAddAppletMode() {
        this.initializeCommon();
        String[] stringArray = new String[]{this.nhmRes.getString("s_chart"), this.nhmRes.getString("s_statAn"), this.nhmRes.getString("s_multNode")};
        Panel panel = new Panel();
        panel.add(new Label(this.nhmRes.getString("s_rptType")));
        this.reportType = new Choice();
        int n = 0;
        while (n < 3) {
            this.reportType.addItem(stringArray[n]);
            ++n;
        }
        this.reportType.select(0);
        panel.add(this.reportType);
        this.add(panel);
        Object[] objectArray = new String[]{this.nhmRes.getString("s_saveAsApplet"), this.nhmRes.getString("s_saveAsImage")};
        this.saveType = JCCheckbox.makeGroup(objectArray, null, true);
        this.saveType.getCheckbox(0).setState(1);
        this.add(this.saveType);
        this.moreHostnames = new JCCheckbox(this.nhmRes.getString("s_moreHost"));
        this.moreHostnames.addItemListener(this);
        this.add(this.moreHostnames);
        this.timePanel = new TimeSelectionPanel(false);
        this.add(this.timePanel);
        this.reportType.addItemListener(this);
        this.saveType.addItemListener(this);
        this.initializeButtons("s_Add");
    }

    private void initializeButtons(String string) {
        Panel panel = new Panel();
        this.buttonOne = new Button(this.nhmRes.getString(string));
        panel.add(this.buttonOne);
        this.pbCancel = new Button(this.nhmRes.getString("s_Cancel"));
        panel.add(this.pbCancel);
        this.pbHelp = new Button(this.nhmRes.getString("s_Help"));
        panel.add(this.pbHelp);
        this.buttonOne.addActionListener(this);
        this.pbCancel.addActionListener(this);
        this.pbHelp.addActionListener(this);
        this.add(panel);
    }

    public String getReportName() {
        return this.filePanel.getSelectedFile();
    }

    public boolean promptForMoreHostnames() {
        boolean bl = false;
        if (this.dialogMode == 3) {
            bl = this.moreHostnames.getState() == 1;
        }
        return bl;
    }

    public boolean addToExistingApplet() {
        boolean bl = false;
        if (this.dialogMode == 3) {
            bl = this.moreHostnames.getState() == 1;
        }
        return bl;
    }

    public void setReportName(String string) {
        this.filePanel.setFileName(string);
    }

    public int getTimeRange() {
        return this.timePanel.getTimeRange();
    }

    public int getTimeLength() {
        return this.timePanel.getTimeLength();
    }

    public boolean getSaveAsImage() {
        return this.saveType.getCheckbox(1).getState() == 1;
    }

    public Date getStartDate() {
        return this.timePanel.getStartDate();
    }

    public Date getEndDate() {
        return this.timePanel.getEndDate();
    }

    public String getAppletType() {
        return this.reportType.getSelectedItem();
    }

    public void setStartDate(Date date) {
    }

    public void setEndDate(Date date) {
    }

    public int getResult() {
        return this.result;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.dialogMode == 3 && itemEvent.getSource() == this.reportType) {
            if (this.nhmRes.getString("s_multNode").equals(itemEvent.getItem())) {
                if (itemEvent.getStateChange() == 1) {
                    this.moreHostnames.setText(this.nhmRes.getString("s_addToExisting"));
                    return;
                }
                this.moreHostnames.setText(this.nhmRes.getString("s_moreHost"));
                return;
            }
            if (this.nhmRes.getString("s_chart").equals(itemEvent.getItem())) {
                if (itemEvent.getStateChange() == 1) {
                    this.saveType.setEnabled(true);
                    return;
                }
                this.saveType.setEnabled(false);
            }
        }
    }

    public void itemStateChanged(JCItemEvent jCItemEvent) {
        if (this.dialogMode == 3) {
            if (jCItemEvent.getSource() == this.saveType.getCheckbox(0) && jCItemEvent.getStateChange() == 1) {
                this.timePanel.setEnabled(true);
                this.reportType.setEnabled(true);
                this.moreHostnames.setEnabled(true);
                return;
            }
            if (jCItemEvent.getSource() == this.saveType.getCheckbox(1) && jCItemEvent.getStateChange() == 1) {
                this.timePanel.setEnabled(false);
                this.reportType.setEnabled(false);
                this.moreHostnames.setEnabled(false);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.buttonOne) {
            if (this.getReportName() != null && this.getReportName().length() > 0) {
                this.result = this.dialogMode;
                this.dispose();
                return;
            }
        } else {
            if (actionEvent.getSource() == this.pbCancel) {
                this.result = 1;
                this.dispose();
                return;
            }
            if (actionEvent.getSource() == this.pbHelp) {
                NhmHelpRef nhmHelpRef = new NhmHelpRef(this);
                if (this.applet instanceof BrowserApplet) {
                    BrowserApplet browserApplet = (BrowserApplet)this.applet;
                    browserApplet.showHelp(nhmHelpRef);
                    return;
                }
                this.applet.getAppletContext().showDocument(nhmHelpRef.getURL(this.applet));
            }
        }
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (windowEvent.getWindow() == this) {
            this.result = 1;
            this.dispose();
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }
}

